//
//  TNKDriveRouteExplain.h
//  TencentNavKit
//
//  Created by mol on 2022/10/10.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKCommonObj.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 驾车路线解释性类型.
 * @since 5.2.4
 */
typedef NS_ENUM(NSUInteger, TNKDriveRouteExplainType) {
    TNKDriveRouteExplainTypeUnknown                   = 0,
    TNKDriveRouteExplainTypeFerry                     = 1,        ///<  轮渡路线
    TNKDriveRouteExplainTypeAvoidCongestion           = 2,        ///<  躲避交通拥堵
    TNKDriveRouteExplainTypeAvoidClosingRoad          = 3,        ///<  躲开封路
    TNKDriveRouteExplainTypeClosingRoad               = 4,        ///<  无法避开封路
    TNKDriveRouteExplainTypeAvoidNarrowRoad           = 5,        ///<  躲开小路
    TNKDriveRouteExplainTypeNarrowRoad                = 6,        ///<  无法避开小路
    TNKDriveRouteExplainTypeAvoidMountainRoad         = 7,        ///<  躲开山路
    TNKDriveRouteExplainTypeMountainRoad              = 8,        ///<  无法避开山路
    TNKDriveRouteExplainTypeLimitAtStart              = 9,        ///<  起点在限行区域
    TNKDriveRouteExplainTypeLimitAtEnd                = 10,       ///<  终点在限行区域
    TNKDriveRouteExplainTypeLimitAtStartAndEnd        = 11,       ///<  起终点在限行区域
    TNKDriveRouteExplainTypeCannotAvoidLimit          = 12,       ///<  无法避免限行区域
    TNKDriveRouteExplainTypeTruckLimitAtStart         = 13,       ///<  货车起点存在交限
    TNKDriveRouteExplainTypeTruckLimitAtEnd           = 14,       ///<  货车终点存在交限
    TNKDriveRouteExplainTypeTruckLimitAtStartAndEnd   = 15,       ///<  货车起终点存在交限
    TNKDriveRouteExplainTypeTruckLimitAtWaypoint      = 16,       ///<  货车途径点存在交限
    TNKDriveRouteExplainTypeAvoidNewClosingRoad       = 17,       ///<  避开新增封闭
    TNKDriveRouteExplainTypeAvoidLimitRoad            = 18,       ///<  避开限行
    TNKDriveRouteExplainTypeAvoidProhibitedEnter      = 19,       ///<  避开禁止驶入
    TNKDriveRouteExplainTypeAvoidNoTurning            = 20,       ///<  避开禁止掉头
    TNKDriveRouteExplainTypeAvoidNoRightTurning       = 21,       ///<  避开禁止右转
    TNKDriveRouteExplainTypeAvoidNoLeftTurning        = 22,       ///<  避开禁止左转
    TNKDriveRouteExplainTypeAvoidNoStraightAhead      = 23,       ///<  避开禁止直行
    TNKDriveRouteExplainTypeTypeInternalRoad          = 24,       ///<  内部路
    TNKDriveRouteExplainTypeAvoidFerry                = 25,       ///<  避开轮渡
    TNKDriveRouteExplainTypeAvoidNo_Hightway          = 26,       ///<  无法不走高速
    TNKDriveRouteExplainTypeDestIsAboutToClose        = 27,       ///<  终点即将打烊
    TNKDriveRouteExplainTypeDestIsClose               = 28,       ///<  终点已打烊
    TNKDriveRouteExplainTypeDestIsResting             = 29,       ///<  终点休息中
    TNKDriveRouteExplainTypeDestIsNotOpenToday        = 30,       ///<  终点当天不营业
    TNKDriveRouteExplainTypeDestIsAboutToOpen         = 31,       ///<  终点即将营业
    TNKDriveRouteExplainTypeDestHasNotYetOpened       = 32,       ///<  终点尚未开放
    TNKDriveRouteExplainTypeDestHasNotYetStartBusiness          = 33,       ///<  终点尚未开业
    TNKDriveRouteExplainTypeDestHasNotYetStartWorking           = 34,       ///<  终点尚未办公
    TNKDriveRouteExplainTypeDestIsTemporarilyClosed             = 35,       ///<  终点暂停开放
    TNKDriveRouteExplainTypeDestIsTemporarilyOutOfBusiness      = 36,       ///<  终点暂停营业
    TNKDriveRouteExplainTypeDestIsTemporarilyNotWorking         = 37,       ///<  终点暂停办公
    TNKDriveRouteExplainTypeDestIsClosed                        = 38,       ///<  终点已关闭
    TNKDriveRouteExplainTypeDestIsUnderConstruction             = 39,       ///<  终点建设中
    TNKDriveRouteExplainTypeDestAreaIsTemporarilyOutOfBusiness  = 40,       ///<  终点（区域面）暂停营业
    TNKDriveRouteExplainTypeDestAreaHasNotYetStartedBusiness    = 41,       ///<  终点（区域面）尚未开业
    TNKDriveRouteExplainTypeDestAreaIsUnderConstruction         = 42,       ///<  终点（区域面）建设中
    TNKDriveRouteExplainTypeCameraOfNew                         = 43,       ///<  新增电子眼
    TNKDriveRouteExplainTypeCameraOfViolation                   = 44,       ///<  违章高发电子眼
    TNKDriveRouteExplainTypePointEventAccident                  = 45,       ///<  点事件-事故
    TNKDriveRouteExplainTypePointEventControl                   = 46,       ///<  点事件-管制
    TNKDriveRouteExplainTypePointEventConstruction              = 47,       ///<  点事件-施工
    TNKDriveRouteExplainTypePointEventObstacle                  = 48,       ///<  点事件-障碍物
    TNKDriveRouteExplainTypePointEventActivity                  = 49,       ///<  点事件-活动
    TNKDriveRouteExplainTypePointEventBadWeather                = 50,       ///<  点事件-恶劣天气
    TNKDriveRouteExplainTypePointEventDisaster                  = 51,       ///<  点事件-灾害
    TNKDriveRouteExplainTypePointEventCheck                     = 52,       ///<  点事件-检查
    TNKDriveRouteExplainTypePointEventWaterlogged               = 53,       ///<  点事件-积水
    TNKDriveRouteExplainTypePointEventNotification              = 54,       ///<  点事件-公告
    TNKDriveRouteExplainTypePassingThroughWaterloggedPoint      = 55,       ///<  经过积水点
    TNKDriveRouteExplainTypeTruckAvoidNoHeight                  = 56,       ///< （货车）无法避开限高
    TNKDriveRouteExplainTypeTruckAvoidNoWidth                   = 57,       ///< （货车）无法避开限宽
    TNKDriveRouteExplainTypeTruckAvoidNoWeight                  = 58,       ///< （货车）无法避开限重
    TNKDriveRouteExplainTypeTruckAvoidNoStraightAhead           = 59,       ///< （货车）无法避开直行交规
    TNKDriveRouteExplainTypeTruckAvoidNoRightTurning            = 60,       ///< （货车）无法避开右转交规
    TNKDriveRouteExplainTypeTruckAvoidNoLeftTurning             = 61,       ///< （货车）无法避开左转交规
    TNKDriveRouteExplainTypeTruckAvoidNoTurning                 = 62,       ///< （货车）无法避开掉头交规
    TNKDriveRouteExplainTypeTruckAvoidNoProhibitedEnter         = 63,       ///< （货车）无法避开禁止驶入交规
};

/**
 * @brief 驾车路线解释性类.
 * @since 5.2.4
 */
@interface TNKDriveRouteExplain : NSObject

/**
 * @brief 驾车路线解释性类型. since 5.2.4
 */
@property (nonatomic, readonly) TNKDriveRouteExplainType type;

/**
 * @brief 路线解释性的点串信息. since 5.2.4
 */
@property (nonatomic, readonly) NSArray<TNKCoordinatePoint *> *points;

/**
 * @brief 路线解释性的描述. since 5.2.4
 */
@property (nonatomic, readonly) NSString *content;

/**
 * @brief 路线解释性起始点索引
 */
@property (nonatomic, readonly) int from;

/**
 * @brief 路线解释性终止点索引
 */
@property (nonatomic, readonly) int to;

/**
 * @brief 透出限行区域规则ID功能. since 6.10.0
 */
@property (nonatomic, readonly) NSArray<NSString *> *detail_ids;

@end

NS_ASSUME_NONNULL_END
