//
//  TNKChangeRouteMsg.h
//  TencentNavKit
//
//  Created by mol on 2022/5/19.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 主路线变化的原因
typedef enum _TNKChangeRouteMsgReason
{
    TNKChangeRouteMsgReasonUnkown           = 0,    ///< 未知
    TNKChangeRouteMsgReasonClicking         = 1,    ///< 司机点击备选路线
    TNKChangeRouteMsgReasonDrivingIn        = 2,    ///< 司机驶入备选路线
    TNKChangeRouteMsgReasonByAPI            = 3,    ///< 开发者调用API切换路线
    TNKChangeRouteMsgReasonRoadClosed       = 4,    ///< 封路导致切换路线
    TNKChangeRouteMsgReasonLimitChanged     = 5,    ///< 交限变化导致切换路线
    TNKChangeRouteMsgReasonReroute          = 6,    ///< 重新算路导致的路线变化
} TNKChangeRouteMsgReason;

/// 主路变化信息
@interface TNKChangeRouteMsg : NSObject

/// 主路线变化的原因
@property (nonatomic, assign) TNKChangeRouteMsgReason reason;

@end

NS_ASSUME_NONNULL_END
