//
//  TencentLBSIonosphereResult.h
//  TencentLBS
//
//  Created by Ranyruan on 2024/3/27.
//  Copyright © 2024 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, TencentLBSIonosStatus) {
    TencentLBSIonosStatusUnkown      = -1,    //!< 还未开启定位或者还没有从服务端获取到值
    TencentLBSIonosStatusInactive    = 0,     //!< 电离层不活跃
    TencentLBSIonosStatusActive      = 1,     //!< 电离层活跃
};

@interface TencentLBSIonosphereResult : NSObject

/**
 * 电离层是否活跃
 */
@property (nonatomic, readonly, assign)TencentLBSIonosStatus ionosStatus;

/**
 * 活跃状态的更新时间
 */
@property (nonatomic, readonly, strong)NSDate *time;

@end

NS_ASSUME_NONNULL_END
