//
//  QIntersectionOverlay.h
//  QMapKit
//
//  Created by Keith Cao on 2020/7/8.
//  Copyright © 2020 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 路口放大图覆盖物
 */
@interface QIntersectionOverlay : NSObject

@property (nonatomic, strong) NSData *data;

@property (nonatomic, strong) NSString  *filePath;

/**
 * @brief 覆盖物的位置
 */
@property (nonatomic, assign) CGRect rect;

@property (nonatomic, assign) BOOL	visible;

@property (nonatomic, assign) BOOL  isDayMode;

@property (nonatomic, assign) BOOL  roundedCorner;

#ifdef DEBUG
/**
 * @brief 白天样式文件位置
 */
@property (nonatomic, copy) NSString *dayModeStylePath;

/**
 * @brief 夜间样式文件位置
 */
@property (nonatomic, copy) NSString *nightModeStylePath;

#endif

@property (nonatomic, assign) NSUInteger leftTopCornerRadius;

@property (nonatomic, assign) NSUInteger rightTopCornerRadius;

@property (nonatomic, assign) NSUInteger leftBottomCornerRadius;

@property (nonatomic, assign) NSUInteger rightBottomCornerRadius;



@end

NS_ASSUME_NONNULL_END
