//
//  TMSStatsReporter.h
//  QMapFoundationKit
//
//  Created by KeithCao on 2022/3/8.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QBaseReportEvent.h"

NS_ASSUME_NONNULL_BEGIN

@interface TMSStatsReporter : NSObject

/// 是否打开开关
@property (nonatomic, assign) BOOL isShowLog;

/// 添加公用上报字段,  所有上报均带有设置的字段
- (void)setCommonReportParams:(NSDictionary*)params;

/// 上报单例
+ (TMSStatsReporter*)reporter;

/// 流量上报接口
- (void)reportNetflowEvent:(QNetflowItem*)item;

/// 上报内容
- (void)reportEvent:(QBaseReportEvent*)event;

/// 上报配置
- (void)setReportCofig:(QBaseReportCofig*)beaconConfig;

/// crash上报内容
- (void)reportCrash:(QReportCrashInfo*)crashInfo;

/// 用量事件内容
- (void)reportUserScene:(QReportCrashUserScene*)userScene;

+ (NSDictionary *)commonCrashValueDict:(QReportCrashInfo*)crashInfo;

@end

NS_ASSUME_NONNULL_END
