//
//  TNKUserLocationPresentation.h
//  TencentNavKit
//
//  Created by mol on 2022/12/21.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// 日夜间自车点配置类， 下列属性如果为nil，则使用默认值
@interface TNKUserLocationConfig : NSObject

/// 自车点图片
@property (nonatomic, strong) UIImage *locatorImage;
/// 信号弱时的自车点图片
@property (nonatomic, strong) UIImage *weakLocatorImage;
/// 东
@property (nonatomic, strong) UIImage *eastImage;
/// 南
@property (nonatomic, strong) UIImage *southImage;
/// 西
@property (nonatomic, strong) UIImage *westImage;
/// 北
@property (nonatomic, strong) UIImage *northImage;
/// 圆环
@property (nonatomic, strong) UIImage *circleImage;
@end

/// 自车点配置类
@interface TNKUserLocationPresentation : NSObject

/// 日间自车点配置。为null则使用默认
@property (nonatomic, strong, nullable)TNKUserLocationConfig *dayUserLocationConfig;

/// 夜间自车点配置。为null则使用默认
@property (nonatomic, strong, nullable)TNKUserLocationConfig *nightUserLocationConfig;

@end

NS_ASSUME_NONNULL_END
