//
//  TNKCarRouteColorQuickSelector.h
//  TencentNavKit
//
//  Created by tabsong on 2021/12/30.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKRouteLineConfig.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief 导航路线样式配置类
 */
@interface TNKRouteConfig : NSObject

/**
 * @brief 导航线在不同场景下的样式配置. 
 * @param mainRouteColorConfig 导航主路线颜色配置，为nil则无法展示路线
 * @param accompanyRouteColorConfig 导航伴随路线颜色配置，为nil则无法展示路线
 *
 * @note TNKCarRouteColorPalette 中的eraseColor 不支持动态更新.
 *
 * @return 导航路线样式配置对象
 */
- (instancetype)initWithMainRouteColorConfig:(TNKRouteLineConfig * __nullable)mainRouteColorConfig
                   accompanyRouteColorConfig:(TNKRouteLineConfig * __nullable)accompanyRouteColorConfig;

/**
 *  @brief 导航主路线样式配置
 */
@property(nonatomic, strong, readonly) TNKRouteLineConfig *mainRouteColorConfig;

/**
 *  @brief 导航伴随路线样式配置
 */
@property(nonatomic, strong, readonly) TNKRouteLineConfig *accompanyRouteColorConfig;


/**
 * @brief 导航过程中路况线上的箭头密度.需在导航开始前设置. 默认值是100.
 * @since 5.2.3.1
 */
@property (nonatomic, assign) CGFloat flowArrowGap;

@end

NS_ASSUME_NONNULL_END
