//
//  TNKParallelRoadStatus.h
//  TencentNavKit
//
//  Created by mol on 2022/11/1.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKDriveCommonObj.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 平行路状态。
 */
@interface TNKParallelRoadStatus : NSObject

/**
 *  @brief 当前道路类型
 */
@property (nonatomic, assign) TNKRoadType currentRoadType;

/**
 *  @brief 第一个可切换的平行路。为TNKRoadType_None时表示没有可切换的平行路
 */
@property (nonatomic, assign) TNKRoadType firstHintRoadType;

/**
 *  @brief 第二个可切换的平行路。为TNKRoadType_None时表示没有第二个可切换的平行路
 */
@property (nonatomic, assign) TNKRoadType secondHintRoadType;

@end

NS_ASSUME_NONNULL_END
