//
//  TNKNaviTrafficBarWidget.h
//  TencentNavKit
//
//  Created by mol on 2019/6/22.
//  Copyright © 2019 Tencent. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <TencentNavKit/TNKDriveNavDelegate.h>

NS_ASSUME_NONNULL_BEGIN


/**
 * @brief 路况光柱图展示方向
 */
typedef NS_ENUM(NSUInteger, TNKNaviTrafficBarWidgetOrientation)
{
    TNKNaviTrafficBarWidgetOrientationVertical = 0,     ///< 垂直展示，由下至上展示路况信息
    TNKNaviTrafficBarWidgetOrientationHorizontal = 1,   ///< 水平展示，由左至右展示路况信息
};

/**
 * @brief 路况光柱图
 */
@interface TNKNaviTrafficBarWidget : UIView<TNKDriveNavDelegate>

/**
 * @brief 视图展示方向，默认为TNKNaviTrafficBarWidgetOrientationVertical
 */
@property(nonatomic, assign) TNKNaviTrafficBarWidgetOrientation orientation;

/**
 * @brief 边框颜色
 */
@property (nonatomic, strong) UIColor *borderColor;

/**
 * @brief 边框宽度
 */
@property (nonatomic, assign) CGFloat borderWidth;

/**
 * @brief 圆角半径
 */
@property (nonatomic, assign) CGFloat cornerRadius;

/**
 * @brief 交通状态的颜色
 *  例如，@{@(TNKRouteTrafficDataStatusSmooth): [UIColor greenColor], @(TNKRouteTrafficDataStatusSlow) : [UIColor yellowColor]}
 */
@property (nonatomic, copy) NSDictionary<NSNumber *, UIColor *> *colorConfig;

/**
 * @brief 在导航开始之前可设置小车的图标以及大小
 * @param icon 小车图标
 * @param size 小车的大小
 */
- (void)setCarIcon:(UIImage *)icon size:(CGSize)size;

/**
 * @brief 光柱图是否表示全程，默认为YES。全程表示偏航后考虑偏航前行驶的里程，车标不会重新回到光柱图底部。
 */
@property (nonatomic, assign, getter=isWholeJourney) BOOL wholeJourney;

@end

NS_ASSUME_NONNULL_END
