//
//  TNKMathTool.h
//  TencentNavKit
//
//  Created by xue on 2018/5/3.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import <QMapKit/QGeometry.h>

@class TNKCoordinatePoint;

/**
 * @brief 数学库类
*/
@interface TNKMathTool : NSObject

/**
 * @brief 计算两点直接的距离
 * @param coordinate1 第一个点的坐标
 * @param coordinate2 第二个点的坐标
 */
+ (double)distanceBetweenCoordinate:(CLLocationCoordinate2D)coordinate1
                         coordinate:(CLLocationCoordinate2D)coordinate2;

/**
 * @brief 获取包裹点串的Rect
 * @param points 坐标点串
 */
+ (QMapRect)mapRectFitsPoints:(NSArray<TNKCoordinatePoint *> *)points;

// 获取Rect
+ (QMapRect)mapRectFitsTwoCoordinates:(CLLocationCoordinate2D)coordinate1
                           coordinate:(CLLocationCoordinate2D)coordinate2;
@end
