//
//  TNKEnlargedMapConfig.h
//  TencentNavKit
//
//  Created by mol on 2023/5/18.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief 放大图配置类
 */
@interface TNKEnlargedMapConfig : NSObject <NSCopying>

/**
 *  @brief 设置在3D车头朝上和2D地图朝北模式下 显示/隐藏路口放大图. 默认为YES
 *         注意不管此参数如何设置，在全览模式和剩余全览模式下都会隐藏.
 */
@property (nonatomic, assign) BOOL enlargedMapEnabled;

/**
 * @brief 路口放大图摆放位置。rect.orgin.x, rect.origin.y, rect.size.width生效, 高由enlargedIntersectionAspect决定
 *        当前正在展示路口放大图时，修改不会立即生效，下次展示路口放大图时生效
 */
@property (nonatomic, assign) CGRect enlargedMapRect;

/**
 * @brief 路口放大图宽高比，取值范围[1.0 , 2.0], 默认值为kTNKEnlargedIntersectionAspect。
 */
@property (nonatomic, assign) CGFloat enlargedMapAspect;

/**
 * @brief 路口放大图中顶部的进度条是否展示，默认为YES
 */
@property (nonatomic, assign) BOOL showEnlargedMapProgressView;

/**
 * @brief 路口放大图左下圆角，默认为20
 */
@property (nonatomic, assign) float bottomLeftCornerRadius;

/**
 * @brief 路口放大图右下圆角，默认为20
 */
@property (nonatomic, assign) float bottomRightCornerRadius;


/**
 * @brief 路口放大图左下圆角，默认为0
 */
@property (nonatomic, assign) float topLeftCornerRadius;

/**
 * @brief 路口放大图右下圆角，默认为0
 */
@property (nonatomic, assign) float topRightCornerRadius;

@end

NS_ASSUME_NONNULL_END
