//
//  TNKDriveNavDataSource.h
//  TencentNavKit
//
//  Created by mol on 2022/12/2.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKDriveNavManager,
TNKNavTTS;


/// 导航特殊事件回调，需要返回值
@protocol TNKDriveNavDataSource <NSObject>

@optional

/**
 * @brief 告知语音播报结果。注意: 该回调发生在导航线程中，这里不可以做耗时操作
 * @param manager manager
 * @param naviTTS tts信息
 * @return 是否播报该文案.0未播报,1已播报.
 */
- (int)driveNavManager:(TNKDriveNavManager *)manager
               naviTTS:(TNKNavTTS *)naviTTS;

@end

NS_ASSUME_NONNULL_END
