//
//  TencentLBSGuideArea.h
//  TencentLBS
//
//  Created by fengli ruan on 2021/12/1.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TencentLBSGeoCoordinateZ : NSObject
/**
 * 经度，小数点后6位
 */
@property (nonatomic, assign)double lng;

/**
 * 纬度，小数点后6位
 */
@property (nonatomic, assign)double lat;

/**
 * 获取高程，单位厘米
 */
@property (nonatomic, assign)float z;

@end

@interface TencentLBSGuideArea : NSObject
/**
 * 系统开机时间 单位ms
 */
@property (nonatomic, assign)int64_t tickTime;

/**
 * 路线ID
 */
@property (nonatomic, readwrite, copy)NSString *routeId;

/**
 * 代表引导面数据是否连续
 * @return 0 不连续，1 连续
 */
@property (nonatomic, assign)int32_t indexOffset;

/**
 * 获取引导面经纬度及高程信息集合
 * @return
 */
@property (nonatomic, readwrite, strong)NSMutableArray<TencentLBSGeoCoordinateZ *> * coordinateZGroup;

/**
 * 引导面ID
 */
@property (nonatomic, readwrite, copy)NSString *guideArea_id;


@end

NS_ASSUME_NONNULL_END
