//
//  TencentLBSGeoFenceRegion.h
//  TencentLBS
//
//  Created by Ranyruan on 2023/5/19.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

NS_ASSUME_NONNULL_BEGIN

///TencentLBSGeoFence Region State
typedef NS_ENUM(NSInteger, TencentLBSGeoFenceRegionStatus)
{
    TencentLBSGeoFenceRegionStatusUnknown  = 0,       ///< 未知
    TencentLBSGeoFenceRegionStatusInside   = 1,       ///< 在范围内
    TencentLBSGeoFenceRegionStatusOutside  = 2,       ///< 在范围外
};

typedef NS_ENUM(NSInteger, TencentLBSGeoFenceRegionType)
{
    TencentLBSGeoFenceRegionTypeCircle     = 0,       /// 圆形地理围栏
    TencentLBSGeoFenceRegionTypePolygon    = 1,       /// 多边形地理围栏
};

///地理围栏任务状态类型
typedef NS_ENUM(NSUInteger, TencentLBSGeoFenceRegionActiveStatus)
{
    TencentLBSGeoFenceRegionActiveUNKown      = 0,       ///< 未注册
    TencentLBSGeoFenceRegionActiveMonitoring  = 1,      ///< 正在监控
    TencentLBSGeoFenceRegionActivePaused      = 2,      ///< 暂停监控
};


typedef NS_ENUM(NSUInteger, TencentLBSLocationSDKAction) {
    TencentLBSLocationSDKActionUnkown                 = 0,              //!< 定位未知状态
    TencentLBSLocationSDKActionStarted                = 1,              //!< 开始了定位
    TencentLBSLocationSDKActionLocationing            = 2,              //!< 正在定位中
    TencentLBSLocationSDKActionLocationErrorUnkown    = 3,              //!< 当前定位失败，正在尝试定位
    TencentLBSLocationSDKActionLocationErrorDenied    = 4,              //!< 定位没有权限
    TencentLBSLocationSDKActionStoped                 = 5,              //!< 停止了定位
};

@interface TencentLBSGeoFenceRegion : NSObject<NSCopying>

///用户自定义ID，可为nil。
@property (nonatomic, copy, readonly) NSString *customID;

//是否正在被监控
@property (nonatomic, assign) TencentLBSGeoFenceRegionActiveStatus activeStatus;

///坐标点和围栏的关系，比如用户的位置和围栏的关系
@property (nonatomic, assign) TencentLBSGeoFenceRegionStatus fenceStatus;

///用户自定义ID，可为nil。
@property (nonatomic, assign) TencentLBSGeoFenceRegionType regionType;

///缓存最近获取的定位信息，可能会存在延时，可为nil，会在获取定位时更新
@property (nonatomic, copy) CLLocation *currentLocation;

//在围栏内停留时长，单位秒
@property (nonatomic, assign) NSTimeInterval stayTimeInside;

@end

#pragma mark - TencentLBSLocationCircleRegion


///圆形地理围栏（since 2.3.0）
@interface TencentLBSGeoFenceCircleRegion : TencentLBSGeoFenceRegion


///中心点的经纬度坐标
@property (nonatomic, readonly) CLLocationCoordinate2D center;


///半径，单位：米
@property (nonatomic, readonly) CLLocationDistance radius;

@end


#pragma mark -TencentLBSGeoFencePolygonRegion


///多边形地理围栏（since 2.3.0）
@interface TencentLBSGeoFencePolygonRegion : TencentLBSGeoFenceRegion


///经纬度坐标点数据
@property (nonatomic, readonly) CLLocationCoordinate2D *coordinates;


///经纬度坐标点的个数
@property (nonatomic, readonly) NSInteger count;


@end


NS_ASSUME_NONNULL_END
