//
//  TNKAudioPlayer.h
//  TencentNaviKit
//
//  Created by mol on 2022/11/18.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKAudioPlayerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@interface TNKAudioPlayer : NSObject <TNKAudioPlayerProtocol>

+ (instancetype)sharedAudioPlayer;

/**
 *  @brief TNKAudioPlayer的回调. 用于接收播报状态等事件.
 */
@property (nonatomic, weak) id <TNKAudioPlayerDelegate> delegate;

/**
 *  @brief 语音播报器是否在播放状态.
 */
@property (nonatomic, readonly) BOOL isPlaying;

/**
 *  @brief 控制音量，设置范围[0, 1]
 *  @since 5.4.3
 */
@property (nonatomic, assign) float volume;

/**
 *  @brief 控制语音播报速度，请在开始播报之前设置完成设置范围[20, 100],默认是50是正常速度（不设置该属性默认也是正常速度），最大支持100是双倍速度
 *  @since 6.9.0
 */
@property (nonatomic, assign) int rate;

/**
 * @brief 播放速度设置。传入其他无效类型不生效 since 6.9.0
 * @param type 播报速度类型
 */
- (void)playWithRate:(TNKAudioPlayRateType)type;

/**
 * @brief 播放自定义文字, 可放入播放队列中。如果执行stop方法，则队列中的播报内容也会被清除。 since 5.3.8
 * @param audioParam 播报信息
 */
- (void)playWithAudioParam:(TNKAudioParam *)audioParam;

/**
 * @brief 播放导航诱导信息
 * @param naviTTS 播报信息
 */
- (void)playWithNaviTTS:(TNKNavTTS *)naviTTS;

/**
 *  @brief 停止当前播报内容.
 */
- (void)stop;


@end

NS_ASSUME_NONNULL_END
