//
//  QTCAutoCodingMacro.h
//  QMapKit
//
//  Created by tabsong on 2023/4/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "NSObject+QTCAutoCoding.h"

#ifndef QTCAutoCodingMacro_h
#define QTCAutoCodingMacro_h

// 自动生成支持NSCopying的代码.
// 需要同时引入 QTC_AUTOCODING_IMPLEMENT_ASSIST
#define QTC_AUTOCODING_IMPLEMENT_NSCOPYING                      \
- (instancetype)copyWithZone:(NSZone *)zone                     \
{                                                               \
    id copy = [[[self class] alloc] init];                      \
    for (NSString *key in self.qtc_getPropertyNames)            \
    {                                                           \
        [copy setValue:[self valueForKey:key] forKey:key];      \
    }                                                           \
    return copy;                                                \
}                                                               \

// 自动生成支持NSCoding的代码.
// 需要同时引入 QTC_AUTOCODING_IMPLEMENT_ASSIST
#define QTC_AUTOCODING_IMPLEMENT_NSCODING                                                   \
- (void)qtc_decodeWithCoder:(NSCoder *)aDecoder                                             \
{                                                                                           \
    NSDictionary *nameToTypeEncoding = self.qtc_getPropertyNames;                           \
    for (NSString *key in nameToTypeEncoding)                                               \
    {                                                                                       \
        id object = [aDecoder decodeObjectForKey:key];                                      \
        id wrapper = [object qtc_decodeObject];                                             \
        if (wrapper)                                                                        \
        {                                                                                   \
            [self setValue:wrapper forKey:key];                                             \
        }                                                                                   \
    }                                                                                       \
}                                                                                           \
- (void)qtc_encodeWithCoder:(NSCoder *)aCoder                                               \
{                                                                                           \
    NSDictionary *nameToTypeEncoding = self.qtc_getPropertyNames;                           \
    for (NSString *key in nameToTypeEncoding)                                               \
    {                                                                                       \
        id object = [self valueForKey:key];                                                 \
        id wrapper = [object qtc_encodeObject];                                             \
        if (wrapper)                                                                        \
        {                                                                                   \
            [aCoder encodeObject:wrapper forKey:key];                                       \
        }                                                                                   \
    }                                                                                       \
}                                                                                           \
- (instancetype)initWithCoder:(NSCoder *)aDecoder                                           \
{                                                                                           \
    [self qtc_decodeWithCoder:aDecoder];                                                    \
    return self;                                                                            \
}                                                                                           \
- (void)encodeWithCoder:(NSCoder *)aCoder                                                   \
{                                                                                           \
    [self qtc_encodeWithCoder:aCoder];                                                      \
}                                                                                           \

// NSCoding/NSCopying 自动代码生成依赖的工具.
#define QTC_AUTOCODING_IMPLEMENT_ASSIST                                                   \
+ (NSDictionary<NSString *, NSString *> *)qtc_generateClassPropertyNames        \
{\
    unsigned int propertyCount;\
    objc_property_t *properties = class_copyPropertyList(self, &propertyCount);\
    NSMutableDictionary *codableProperties = [NSMutableDictionary dictionary];\
    for (unsigned int i = 0; i < propertyCount; i++)\
    {\
        objc_property_t property = properties[i];\
        const char *propertyName = property_getName(property);\
        NSString *key = @(propertyName);\
        char *typeEncoding = property_copyAttributeValue(property, "T");\
        NSString *value = @(typeEncoding);\
        BOOL supported = NO;\
        switch (typeEncoding[0])\
        {\
            case '@':\
            case 'c':\
            case 'i':\
            case 's':\
            case 'l':\
            case 'q':\
            case 'C':\
            case 'I':\
            case 'S':\
            case 'L':\
            case 'Q':\
            case 'f':\
            case 'd':\
            case 'B':\
            case '{':\
            {\
                supported = YES;\
                break;\
            }\
            default:\
            {\
                supported = NO;\
                break;\
            }\
        }\
        if (supported)\
        {\
            char *ivar = property_copyAttributeValue(property, "V");\
            if (ivar)\
            {\
                __autoreleasing NSString *ivarName = @(ivar);\
                if ([ivarName isEqualToString:key] || [ivarName isEqualToString:[@"_" stringByAppendingString:key]])\
                {\
                    codableProperties[key] = value;\
                }\
                free(ivar);\
            }\
            else\
            {\
                char *dynamic = property_copyAttributeValue(property, "D");\
                char *readonly = property_copyAttributeValue(property, "R");\
                if (dynamic && !readonly)\
                {\
                    codableProperties[key] = value;\
                }\
                free(dynamic);\
                free(readonly);\
            }\
        }\
        free(typeEncoding);\
    }\
    free(properties);\
    return codableProperties;\
}\
- (NSDictionary<NSString *, NSString *> *)qtc_getPropertyNames\
{\
    NSDictionary *propertyNames = objc_getAssociatedObject([self class], _cmd);\
    if (!propertyNames)\
    {\
        NSMutableDictionary *tmpPropertyNames = [NSMutableDictionary dictionary];\
        Class subclass = [self class];\
        while (subclass != [NSObject class])\
        {\
            [tmpPropertyNames addEntriesFromDictionary:[subclass qtc_generateClassPropertyNames]];\
            subclass = [subclass superclass];\
        }\
        propertyNames = [NSDictionary dictionaryWithDictionary:tmpPropertyNames];\
        objc_setAssociatedObject([self class], _cmd, propertyNames, OBJC_ASSOCIATION_RETAIN);\
    }\
    return propertyNames;\
}\



#endif /* QTCAutoCodingMacro_h */
