//
//  QTCAutoCodingHeader.h
//  QMapKit
//
//  Created by tabsong on 2023/4/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "QTCAutoCodingMacro.h"
#import "QTCAutoCodingCenter.h"
#import "QTCObjcTypeAutoCodingBaseWrapper.h"
#import "QTCObjcTypeAutoCoding.h"


/*
 * 一：这是啥?
 * QTCAutoCoding是可以自动化的生成Objective-c支持NSCoding/NSCopying协议的代码.
 *
 * 二：如何使用?
 *
 *       第一步: 在类声明中添加 NSCoding, NSCopying
 *       @interface QMSBaseResult : NSObject <NSCopying, NSCoding>
 *
 *       第二步: 引用头文件
 *       #import <QMapFoundation/QTCAutoCodingHeader.h>
 *
 *       第二步: 在类的实现中引入宏定义
 *       @implementation QMSBaseResult
 *
 *       QTC_AUTOCODING_IMPLEMENT_NSCOPYING
 *       QTC_AUTOCODING_IMPLEMENT_NSCODING
 *       QTC_AUTOCODING_IMPLEMENT_ASSIST
 *
 *       @end
 *
 * 三：世面上已有轮子，为啥还要重复造轮子?
 * 轮子：
 *  1. AutoCoding https://github.com/nicklockwood/AutoCoding
 *  2. https://github.com/greenisus/NSObject-NSCoding/blob/master/NSObject+NSCoding.m
 *
 * 但是却无法支持结构体的自动化NSCoding，比如
 *
 *  *. @property (nonatomic) CLLocationCoordinate2D coordinate
 *  *. @property (nonatomic) NSValue *value                       // NSValue 内部使用 CLLocationCoordinate2D 填充.
 *  *. @property (nonatomic) NSArray<NSValue *> *values           // NSValue 内部使用 CLLocationCoordinate2D 填充.
 *  *. @property (nonatomic) NSArray<NSArray<NSValue *>> *values  // NSValue 内部使用 CLLocationCoordinate2D 填充.
 *
 *  为了解决struct无法支持NSCopying协议，我们构建了AutoCoding方案.
 *
 * 四：目前支持了哪些类型的NSCoding/NSCopying?
 *
 *     TypeEncodings            是否支持                    含义
 *     c                        YES                        A char
 *     i                        YES                        An int
 *     s                        YES                        A short
 *     l                        YES                        A long l is treated as a 32-bit quantity on 64-bit programs.
 *     q                        YES                        A long long
 *     C                        YES                        An unsigned char
 *     I                        YES                        An unsigned int
 *     S                        YES                        An unsigned short
 *     L                        YES                        An unsigned long
 *     Q                        YES                        An unsigned long long
 *     f                        YES                        A float
 *     d                        YES                        A double
 *     B                        YES                        A C++ bool or a C99 _Bool
 *     v                        NO                         A void
 *     *                        NO                         A character string (char *)
 *     @                        YES                        An object (whether statically typed or typed id)
 *     #                        NO                         A class object (Class)
 *     :                        NO                         A method selector (SEL)
 *     [array type]             NO                         An array
 *     {name=type...}           YES                        A structure
 *     (name=type...)           NO                         A union
 *     bnum                     NO                         A bit field of num bits
 *     ^type                    NO                         A pointer to type
 *     ?                        NO                         An unknown type (among other things, this code is used for function pointers)
 *
 *
 *     当前仅仅支持了struct 中的 CLLocationCoordinate2D 类型。
 *
 * 五：如何扩展自定义的结构体数据类型?
 * 1. 参考 QTCAutoCodingCLLocationCoordinate2DWrapper 类的实现.
 * 2. 参考 QTCAutoCodingCenter 来注册 结构体的包装类.
 *
 */

