//
//  QTCAutoCodingCenter.h
//  QMapKit
//
//  Created by tabsong on 2023/4/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QTCObjcTypeAutoCoding.h"

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief 自定义 包装器 的注册中心.
 */
@interface QTCAutoCodingCenter : NSObject

/**
 *  @brief 单例
 */
+ (QTCAutoCodingCenter *)center;

/**
 *  @brief 注册 包装器
 *  内部会以 [cls qtc_supportedObjcType] 作为key 来存储，相同的key会冲掉前者.
 *
 *  @param cls 符合 QTCObjcTypeAutoCoding 协议的类.
 */
- (void)registerObjcTypeWrapperClass:(Class)cls;

@end

NS_ASSUME_NONNULL_END
