//
//  TNKTollStationInfo.h
//  TNKNavigationKit
//
//  Created by mol on 2023/2/28.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


/// 分段收费站信息
@interface TNKTollStationItem : NSObject

/// 进入的收费站名称
@property (nonatomic, readonly) NSString *enStationName;
/// 出收费站名称
@property (nonatomic, readonly) NSString *extStationName;

/// 费用，单位：元
@property (nonatomic, readonly) int fee;

@end

/// 途经的收费站信息
@interface TNKTollStationInfo : NSObject

/// 所有做过的分段收费站信息
@property (nonatomic, readonly) NSArray<TNKTollStationItem *> *tollStationItems;

@end

NS_ASSUME_NONNULL_END
