//
//  TNKCarRouteColorConfig.h
//  TencentNavKit
//
//  Created by tabsong on 2022/1/4.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKRouteColorPalette.h>

NS_ASSUME_NONNULL_BEGIN

/// 导航路线颜色配置.
@interface TNKRouteLineConfig : NSObject

/**
 * @brief 导航线在不同场景下的样式配置.
 * @param dayFillColorPalette  白天导航路线填充色颜色盘
 * @param dayStrokeColorPalette 白天导航路线描边色颜色盘
 * @param nightFillColorPalette 夜间导航路线填充色颜色盘
 * @param nightStrokeColorPalette 夜间导航路线描边色颜色盘
 * @return 导航路线样式配置对象
 */
- (instancetype)initWithDayFillColorPalette:(TNKRouteColorPalette * __nullable)dayFillColorPalette
                      dayStrokeColorPalette:(TNKRouteColorPalette * __nullable)dayStrokeColorPalette
                      nightFillColorPalette:(TNKRouteColorPalette * __nullable)nightFillColorPalette
                    nightStrokeColorPalette:(TNKRouteColorPalette * __nullable)nightStrokeColorPalette;

/**
 *  @brief 白天导航路线填充色颜色盘
 */
@property (nonatomic, strong, readonly) TNKRouteColorPalette *dayFillColorPalette;

/**
 *  @brief 白天导航路线描边色颜色盘
 */
@property (nonatomic, strong, readonly) TNKRouteColorPalette *dayStrokeColorPalette;

/**
 *  @brief 夜间导航路线填充色颜色盘
 */
@property (nonatomic, strong, readonly) TNKRouteColorPalette *nightFillColorPalette;

/**
 *  @brief 夜间导航路线描边色颜色盘
 */
@property (nonatomic, strong, readonly) TNKRouteColorPalette *nightStrokeColorPalette;

/**
 * @brief 设置地图绘制路线的线宽. 默认值为14。有效范围[0,30]
 */
@property (nonatomic, assign) float width;

@end

NS_ASSUME_NONNULL_END
