//
//  TNKLogger.h
//  TencentNavKit
//
//  Created by Tencent on 2018/3/5.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

/// 日志等级
typedef enum TNKLogLevel {
    TNKLogLevelDEBUG = 0,
    TNKLogLevelINFO = 1,
    TNKLogLevelWARNING = 2,
    TNKLogLevelERROR = 3,
} _TNKLogLevel;

/**
 * @brief 日志管理类
 */
@interface TNKLogger : NSObject

/**
 * @brief 文件夹路径
 */
@property (nonatomic, readonly) NSString *fileDirPath;

/**
 * @brief 获取实例
 */
+ (instancetype)sharedInstance;

/**
 * @brief 开启/关闭导航日志控输出
 */
- (void)setLogOn:(BOOL)logOn;

/**
 * @brief 写入日志
 */
- (void)writeLogText:(NSString *)text;

@end
