//
//  TNKLocation.h
//  TencentNavKit
//
//  Created by xue on 2018/11/22.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

NS_ASSUME_NONNULL_BEGIN


/**
 * @brief 导航的定位信息.
 */
@interface TNKLocation : NSObject

/**
 * @brief 导航的原始定位信息.
 */
@property (nonatomic, readonly) CLLocation *location;

/**
 * @brief 吸附到导航路线上的位置索引. 若未成功吸附到路线上会返回-1
 */
@property (nonatomic, readonly) NSInteger matchedIndex;

/**
 * @brief 导航吸附信息所属的路线ID.
 */
@property (nonatomic, readonly, nullable) NSString *routeID;

/**
 * @brief 吸附到导航路线上的经纬度信息. 若未成功吸附到路线上会返回kCLLocationCoordinate2DInvalid.
 */
@property (nonatomic, readonly) CLLocationCoordinate2D matchedCoordinate;

/**
 * @brief 吸附到导航路线上的角度信息. 若未成功吸附到路线上会返回-1.0
 */
@property (nonatomic, readonly) CLLocationDirection matchedCourse;

/**
 * @brief 手机的朝向。
 */
@property (nonatomic, readonly) double phoneDir;

/**
 * @brief 该点是否是惯性导航模拟点
 */
@property (nonatomic, readonly) BOOL mockGPS;

/**
 * @brief 剩余距离， 单位：米
*/
@property (nonatomic, readonly) int remainingDistance;

/**
 * @brief 剩余时间，单位：分钟
 */
@property (nonatomic, readonly) int remainingTime;

/**
 * @brief 实时剩余红绿灯个数
 * @since 5.2.8
 */
@property (nonatomic, readonly) int remainTrafficLightCount;

@end

NS_ASSUME_NONNULL_END
