//
//  TNKIdleSectionInfo.h
//  TencentNavKit
//
//  Created by mol on 2022/7/18.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum _TNKIdleSectionType
{
    TNKIdleSectionTypeHigh = 0,     ///< 优先级高。可用于插入高优的业务播报
    TNKIdleSectionTypeLow = 1,      ///< 优先级低。可插入低优和高优的业务播报
} TNKIdleSectionType;

/// 进入空闲区间的信息
@interface TNKIdleSectionInfo : NSObject

/// 空闲区间的长度，单位：米
@property (nonatomic, assign) int distance;

/// 空闲区间的优先级
@property (nonatomic, assign) TNKIdleSectionType idleSectionType;

@end

NS_ASSUME_NONNULL_END
