//
//  TNKCommonObj.h
//  TencentNavKit
//
//  Created by mol on 2022/7/26.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CLLocation.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum _TNKTravelMode
{
    TNKTravelModeDriving  = 0,  ///< 驾车
    TNKTravelModeRiding   = 1,  ///< 骑行
    TNKTravelModeWalking  = 2,  ///< 步行
} TNKTravelMode;     ///< 出行方式


typedef enum _TNKSearchNavPointAdsorbType
{
    TNKSearchNavPointAdsorbTypeDefault =  0,    ///< 默认
    TNKSearchNavPointAdsorbTypeStation =  1,    ///< 场站策略
    TNKSearchNavPointAdsorbTypeAvoidPoi = 5,    ///< 去掉反查逻辑
} TNKSearchNavPointAdsorbType;     ///< 起终点吸附逻辑

/**
 * @brief 导航开启失败错误内容
 */
typedef enum _TNKNavStartFailCode {
    TNKNavStartFailCodeAlreadyStarted = 1001, ///< 已开启导航
    TNKNavStartFailCodeRoutePlanEmpty = 2001, ///< 路径规划为空
    TNKNavStartFailCodeRoutePlanError = 2002, ///< 路径规划失败
    TNKNavStartFailCodeRouteIdEmpty = 3001, ///< 路线ID为空
    TNKNavStartFailCodeRouteIdNotExist = 3002, ///< 路线ID不存在
    TNKNavStartFailCodeInternalError = 3002, ///< 内部错误
} TNKNavStartFailCode;

/// 经纬度类
@interface TNKCoordinatePoint : NSObject<NSCopying>

/// 坐标，必填
@property (nonatomic, assign) CLLocationCoordinate2D coordinate;

@end

/// 路线上的坐标类
@interface TNKRoutePoint : NSObject<NSCopying>

/// 坐标，必填
@property (nonatomic, assign) CLLocationCoordinate2D coordinate;

/// 所在路线点串上的索引
@property (nonatomic, assign) int pointIndex;

/// 距索引点的偏移距离
@property (nonatomic, assign) int offsetDistance;

@end


/// 导航算路起点、终点、途经点所使用的类
@interface TNKSearchNavPoint : TNKCoordinatePoint<NSCopying>

/// poi id
@property (nonatomic, copy, nullable) NSString *poiID;
/// 名称
@property (nonatomic, copy, nullable) NSString *title;
/// 起终点吸附逻辑
@property (nonatomic, assign) TNKSearchNavPointAdsorbType adsorbType;

/**
 * @brief 做为途经点的唯一标识使用。开发者算路时可生成一个唯一标识给该字段赋值
 */
@property (nonatomic, copy) NSString *searchUID;

@end

/// 算路请求类
@interface TNKRouteRequest: NSObject

/// 导航起点，必填
@property (nonatomic, strong) TNKSearchNavPoint *origin;
/// 导航终点，必填
@property (nonatomic, strong) TNKSearchNavPoint *destination;

@end

/**
 * @brief 步骑行里程碑类
 */
@interface TNKRouteMilestone : NSObject

/**
 * @brief 坐标
 */
@property (nonatomic, readonly) CLLocationCoordinate2D coordinate;

/**
 * @brief 所在路线点串index
 */
@property (nonatomic, readonly) int pointIndex;

/**
 * @brief 里程碑的里程. 单位: 米
 */
@property (nonatomic, readonly) int distance;

@end


NS_ASSUME_NONNULL_END
